package lib.DAO.Query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * テーブルデータ全取得Queryクラス
 * @author t_horimatsu
 */
public class TableDataQuery extends CommonQuery<HashMap<String,String>>{
	private String[] getColumnName = null;

	/**
	 * コンストラクタ
	 * @param connection
	 */
	public TableDataQuery(String[] schemeAry){
		super(schemeAry);
	}

	/**
	 * 取得対象のテーブル名をセットする
	 * @param getColumnName テーブル名の配列
	 */
	public void setColumnName(String[] getColumnName) {
		this.getColumnName = getColumnName;
	}

	/**
	 * SQLにより取得した行を任意の形に成形する
	 * @throws Exception 
	 */
	@Override
	public HashMap<String,String> mapRow(ResultSet rs) throws SQLException {
		HashMap<String,String> map = new HashMap<String,String>();

		for(int i = 0;i < getColumnName.length;i++) {
			String name = getColumnName[i];

			String column = rs.getString(name);

			map.put(name, column);
		}
		return map;
	}
}
